#!/bin/bash
#Copyright (c) 2021-2023 by Ivanti, Inc. All rights reserved

SERVICE="pulsesecure"
do_start()
{
    pid=`/usr/bin/pgrep -x "$SERVICE"`
    if [ -z $pid ]; then
        /opt/pulsesecure/bin/pulsesecure  
        if /usr/bin/pgrep -x "$SERVICE" > /dev/null
        then
            /usr/bin/logger "$SERVICE started successfully !!" 
        else
            /usr/bin/logger "$SERVICE failed to start !!!"
        fi
    else
        /usr/bin/logger "$SERVICE already running "
    fi
}

do_stop()
{
    pid=`/usr/bin/pgrep -x "$SERVICE"`
    if [ $pid ];then 
        /usr/bin/kill -SIGTERM $pid
        pid=`/usr/bin/pgrep -x "$SERVICE"`
        if [ $pid ]; then
            /usr/bin/logger "Unable to stop $SERVICE, forcefully stopping !!!"
            /usr/bin/kill -9 $pid
        fi
    else
        /usr/bin/logger "$SERVICE already stopped !!!"
    fi 
}


case "$1" in
start)
    do_start
    ;;
stop)
    do_stop
    ;;
restart)
    do_stop
    do_start
    ;;
esac

exit 0
