# Copyright (c) 2011-2021 by Pulse Secure, LLC. All rights reserved
# LogsAndDiagnostics.sh 
# This is a shell script to save logs&diagnostics for Pulse on Mac OS/X platforms.
# This also belongs to liblogsAndDiagnostics.a (in junsSDK), which provides a thin 
# static-lib wrapper for Pulse UI to call this script in a interruptible way and it
# also provides progress updates tp Pulse UI for display purposes. 


# Initializing...
echo 'Initializing...'
rm -f "$1"    # delete old file


# create temporary directory
rm -rf /tmp/pulsesecure
mkdir -p /tmp/pulsesecure/network

# Saving Diagnostics info...
echo 'Saving Diagnostics info...'
cd /tmp/pulsesecure/network; set > set.txt
cd /tmp/pulsesecure/network; ifconfig > ifconfig.txt
cd /tmp/pulsesecure/network; netstat -nra > netstat.txt
cd /tmp/pulsesecure/network; netstat -s > netstat-s.txt
cd /tmp/pulsesecure/network; ip addr > ipaddr.txt
cd /tmp/pulsesecure/network; ip link > iplink.txt
cd /tmp/pulsesecure/network; cp /etc/resolv.conf resolvconf.txt
cd /tmp/pulsesecure/network; ip route > iproute.txt 
cd /tmp/pulsesecure/network; ip -6 route > ip6route.txt
cd /tmp/pulsesecure/network; cp /usr/share/dbus-1/system.d/net.psecure.pulse.conf pulseconf.txt
cd /tmp/pulsesecure/network; netstat -nr > netstat-nr.txt
cd /tmp/pulsesecure/network; ifconfig > ifconfig.txt

if [ -f /usr/bin/dpkg ];
then
    cd /tmp/pulsesecure/network; dpkg --list > dpkglist.txt
fi

if [ -f /usr/bin/rpm ];
then
    cd /tmp/pulsesecure/network; rpm -qa > rpmlist.txt
fi

cd /tmp/pulsesecure; zip "$1" network/*

# Saving Configuration files...
echo 'Saving Configuration files...'
cd /opt/pulsesecure/lib/JUNS/; zip "$1" access.ini
#Enable below two when we support respective features
#cd /; zip "$1" tmp/pulse*    #capture manifest file generated by iveCM for component upgrade checking
#cd <>; zip "$1" pulse.pac     #capture pulse.pac for proxy

# Saving Database files...
echo 'Saving Database files...'
cd /var/lib/pulsesecure; zip "$1" pulse/connstore.*

# Saving DebugLog and FirewallKextLog files...
echo 'Saving DebugLog files...'
mkdir -p /tmp/pulsesecure/logs
ln -sf /var/log/pulsesecure/logging/debuglog.log /tmp/pulsesecure/logs/debuglog.log
ln -sf /var/log/pulsesecure/logging/debuglog.log.old /tmp/pulsesecure/logs/debuglog.log.old
ln -sf /var/log/pulsesecure/logging/PulseClient.log /tmp/pulsesecure/logs/PulseClient.log
ln -sf /var/log/pulsesecure/logging/PulseClient.log.old /tmp/pulsesecure/logs/PulseClient.log.old
CEF_LOG_NAME="cefinstaller.log"
CEF_LOG="/var/log/pulsesecure/logging/$CEF_LOG_NAME"
if [ -f "$CEF_LOG" ]; then
    ln -sf "$CEF_LOG" /tmp/pulsesecure/logs/$CEF_LOG_NAME
fi
CEF_TMP_LOG="/tmp/$CEF_LOG_NAME"
if [ -f $CEF_TMP_LOG ]; then
    ln -sf $CEF_TMP_LOG /tmp/pulsesecure/logs/tmp_$CEF_LOG_NAME
fi
CEF_DBG_LOG="$HOME/.pulsesecure/cef_browser.log"
CEF_STD_ERR_LOG="$HOME/.pulsesecure/cef_browser_stderr.log"
if [ -f $CEF_DBG_LOG ]; then
    ln -sf $CEF_DBG_LOG /tmp/pulsesecure/logs/cef_browser.log
fi
if [ -f $CEF_STD_ERR_LOG ]; then
    ln -sf $CEF_STD_ERR_LOG /tmp/pulsesecure/logs/cef_browser_stderr.log
fi
SYSLOG=/var/log/syslog
if [ -f $SYSLOG ]; then
    tail -10000 $SYSLOG > /tmp/pulsesecure/logs/system.log
elif [ -f /usr/bin/journalctl ]; then
    journalctl | tail -10000 > /tmp/pulsesecure/logs/system.log
fi

cd /tmp/pulsesecure; zip -r "$1" logs

#Ubuntu crash location
CrashDumpDir=/var/crash/

#Fedora crash location
if [ ! -d "$CrashDumpDir" ]; then
    CrashDumpDir=/var/lib/systemd/coredump/
fi
#take only max of 10 files. Dont make the zip so big
CrashFiles=`ls -t $CrashDumpDir | grep -i "pulseUI\|jamCommand\|cefSubprocess\|pulsesecure\|pulselauncher\|cefBrowser" | head -n10`

mkdir -p /tmp/pulsesecure/CrashDumps
cd /tmp/pulsesecure/

for crashFile in $CrashFiles; do
    echo $CrashDumpDir$crashFile
    cp $CrashDumpDir$crashFile CrashDumps
done

cd /tmp/pulsesecure;  zip -r "$1"  CrashDumps

rm -rf /tmp/pulsesecure

# Succeeded saving zip file: "$1"
echo 'Succeeded saving zip file: '"$1"
ls -l "$1"
